<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Check if the columns already exist
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'checkout_request_id'");
    $checkoutRequestIdExists = $stmt->rowCount() > 0;
    
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'status'");
    $statusExists = $stmt->rowCount() > 0;
    
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'mpesa_receipt'");
    $mpesaReceiptExists = $stmt->rowCount() > 0;
    
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'transaction_date'");
    $transactionDateExists = $stmt->rowCount() > 0;
    
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'updated_at'");
    $updatedAtExists = $stmt->rowCount() > 0;
    
    // Add missing columns
    if (!$checkoutRequestIdExists) {
        $pdo->exec("ALTER TABLE credit_payments ADD COLUMN checkout_request_id VARCHAR(255) NULL");
        echo "Added checkout_request_id column to credit_payments table\n";
    }
    
    if (!$statusExists) {
        $pdo->exec("ALTER TABLE credit_payments ADD COLUMN status ENUM('pending', 'completed', 'failed') DEFAULT 'completed'");
        echo "Added status column to credit_payments table\n";
    }
    
    if (!$mpesaReceiptExists) {
        $pdo->exec("ALTER TABLE credit_payments ADD COLUMN mpesa_receipt VARCHAR(255) NULL");
        echo "Added mpesa_receipt column to credit_payments table\n";
    }
    
    if (!$transactionDateExists) {
        $pdo->exec("ALTER TABLE credit_payments ADD COLUMN transaction_date VARCHAR(50) NULL");
        echo "Added transaction_date column to credit_payments table\n";
    }
    
    if (!$updatedAtExists) {
        $pdo->exec("ALTER TABLE credit_payments ADD COLUMN updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
        echo "Added updated_at column to credit_payments table\n";
    }
    
    // Add index for checkout_request_id if it doesn't exist
    $stmt = $pdo->query("SHOW INDEX FROM credit_payments WHERE Key_name = 'idx_checkout_request_id'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE credit_payments ADD INDEX idx_checkout_request_id (checkout_request_id)");
        echo "Added index for checkout_request_id\n";
    }
    
    echo "M-Pesa fields migration completed successfully\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?> 